<?php 
	$gateway_version = '1.4.6';
	$php_version	 = phpversion();
	
	
	include 'inc/config.php';
	include 'inc/functions.php';
	
	
	$ip = getIP();
	
	if(in_array($ip, $allowed_ips)){
		
		log_to_file($logfolder, "getGateway opgevraagd vanuit toegelaten IP $ip");
		
		$arr_installed_modules = array();
		
		if(file_exists('ActiveDirectory')){
			$arr_installed_modules[] = 'ActiveDirectory';
		}
		
		if(file_exists('poorten')){
			$arr_installed_modules[] = 'poorten';
		}
		
		if(file_exists('uniflow_edu')){
			$arr_installed_modules[] = 'UniflowEdu';
		}
				
		$arr_data = array();
		$arr_data['toolbox_gateway_version'] = $gateway_version;
		$arr_data['gateway_php_version']     = $php_version;
		$arr_data['installed_modules']       = $arr_installed_modules;
		$arr_data['allowed_ips']       		 = $allowed_ips;
		$arr_data['logfolder']       		 = $logfolder;
		$arr_data['current_user']       	 = get_current_user();
		
		echo json_encode($arr_data);

	}
	else {
		log_to_file($logfolder, "getGateway opgevraagd vanuit niet toegelaten IP $ip");
		echo "Fout: verbinding vanuit dit IP-adres ($ip) niet toegestaan!";
	}




?>